<?php
$del = 100;
$fit_thumb = get_sub_field('fit_thumb');
$offer_id = get_sub_field('offer_id');
$show_text = get_sub_field('show_text');
$show_vertical = get_sub_field('show_vertical');
$show_slider = get_sub_field('show_slider');
$slider_columns = get_sub_field('slider_columns');

if (get_sub_field('product_content') == 'products') {
	if (get_sub_field('product_shown_type') == 'promo') {
		$product = new WP_Query(
			array(
				'post_type' => 'product',
				'orderby' => 'menu_order',
				'order' => 'ASC',
				'post_status' => 'publish',
				'post_parent' => 0,
				'posts_per_page' => -1,
				'ignore_sticky_posts'=> 1,
				'meta_query' => array(
					array(
						'key' => 'promo',
						'value' => '1',
						'compare' => 'LIKE'
					)
				)
			)
		);
	} elseif (get_sub_field('product_shown_type') == 'new') {
		$product = new WP_Query(
			array(
				'post_type' => 'product',
				'orderby' => 'menu_order',
				'order' => 'ASC',
				'post_status' => 'publish',
				'post_parent' => 0,
				'posts_per_page' => -1,
				'ignore_sticky_posts'=> 1,
				'meta_query' => array(
					array(
						'key' => 'new',
						'value' => '1',
						'compare' => 'LIKE'
					)
				)
			)
		);
	} else {
		$product = new WP_Query(
			array(
				'post_type' => 'product',
				'orderby' => 'menu_order',
				'order' => 'ASC',
				'post_status' => 'publish',
				'post_parent' => 0,
				'posts_per_page' => -1,
				'ignore_sticky_posts'=> 1
			)
		);
	}

	if ( $product->have_posts() ) : ?>
		<div class="row product-list text-center<?php if ($show_slider) echo ' owl-carousel owl-'.$slider_columns.'-loop'; ?>">
			<?php while ( $product->have_posts() ) : $product->the_post(); ?>
				<div id="id-<?php the_ID(); ?>" class="<?php if ($show_vertical) echo 'row'; elseif (!$show_slider) echo 'col-sm-8 product-item'; ?> marginbottom wow flipInY" data-wow-delay="<?php echo $del; ?>ms" data-wow-duration="1000ms">
					<?php if ( has_post_thumbnail() ) {
						$thumb_id = get_post_thumbnail_id($post->ID); ?>
						<div class="thumbnail-cover thumbnail-200" style="background-image:url(<?php echo wp_get_attachment_url($thumb_id); ?>);"><a href="<?php the_permalink(); ?>" class="link-absolute"></a></div>									
					<?php } ?>
					<h3 class="relative font-additional"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>

					<?php if ($show_text) {
						the_excerpt();
					} ?>
				</div>
				<?php $del = $del + 150; ?>
			<?php endwhile; ?>
		</div>
	<?php endif;
	wp_reset_query();
} else {
	$tax_name = 'product_category';

	$get_terms_args = array(
		'orderby' => 'name',
		'hierarchical' => 1,
		'taxonomy' => $tax_name
	);

	$categories = apply_filters('taxonomy-images-get-terms', '', array(
			'taxonomy' => $tax_name,
			'having_images' => false,
			'term_args' => $get_terms_args
		)
	);
	?>
			
	<div class="row product-list text-center<?php if ($show_slider) echo ' owl-carousel owl-'.$slider_columns.'-loop'; ?>">
		<?php foreach ($categories as $cat) { ?>
			<div class="<?php if ($show_vertical) echo 'row'; elseif (!$show_slider) echo 'col-sm-12 col-md-6 product-item'; ?> marginbottom wow flipInY" data-wow-delay="<?php echo $del; ?>ms" data-wow-duration="1000ms">
				<?php if ($cat->image_id) {
					$image_url = wp_get_attachment_url($cat->image_id); ?>
					<div class="thumbnail-contain thumbnail-200" style="background-image:url(<?php echo $image_url; ?>);"><a href="<?php echo esc_url(get_term_link($cat)); ?>" class="link-absolute"></a></div>									
				<?php } ?>
				<h3 class="relative font-additional"><a href="<?php echo esc_url(get_term_link($cat)); ?>"><?php echo $cat->name; ?></a></h3>
				<?php if ($show_text) { ?>
					<p><?php echo $cat->description; ?></p>
				<?php } ?>
			</div>
			<?php $del = $del + 150; ?>
		<?php } ?>
	</div>
<?php } ?>

<?php $extra_site = get_sub_field('extra_site');
if( $extra_site ): ?>
	<?php foreach( $extra_site as $post): ?>
		<?php setup_postdata($post); ?>
		<div id="id-<?php the_ID(); ?>" class="<?php if ($show_vertical) echo 'row'; elseif (!$show_slider) echo 'col-sm-12 col-md-6 product-item'; ?> marginbottom wow flipInY" data-wow-delay="<?php echo $del; ?>ms" data-wow-duration="1000ms">
			<?php if (has_post_thumbnail()) {
				$thumb_id = get_post_thumbnail_id($post->ID); ?>
				<div class="thumbnail-contain thumbnail-200" style="background-image:url(<?php echo wp_get_attachment_url($thumb_id); ?>);"><a href="<?php the_permalink(); ?>" class="link-absolute"></a></div>									
			<?php } ?>
			<h3 class="relative font-additional"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
		</div>
		<?php $del = $del + 150; ?>
	<?php endforeach; ?>
	<?php wp_reset_postdata(); ?>
<?php endif; ?>
